/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.PatchSpreader;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5819;

public interface Weatherable {
    public static final class_2754<WeatheringState> WEATHERABLE = class_2754.method_11850((String)"weathering", WeatheringState.class);

    public boolean shouldWeather(class_2680 var1, class_2338 var2, class_1937 var3);

    public boolean isWeathering(class_2680 var1);

    public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> var1);

    default public float getWeatherChanceSpeed() {
        return 0.1f;
    }

    public void tryWeather(class_2680 var1, class_3218 var2, class_2338 var3, class_5819 var4);

    default public class_2680 getWeatheredStateForPlacement(class_2680 state, class_2338 pos, class_1937 level) {
        if (state != null) {
            WeatheringState weathering = this.shouldWeather(state, pos, level) ? WeatheringState.TRUE : WeatheringState.FALSE;
            state = (class_2680)state.method_11657(WEATHERABLE, (Comparable)((Object)weathering));
        }
        return state;
    }

    default public void updateWeatheredStateOnNeighborChanged(class_2680 state, class_1937 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            WeatheringState current = (WeatheringState)((Object)state.method_11654(WEATHERABLE));
            if (!current.isStable()) {
                WeatheringState wantedState;
                WeatheringState weatheringState = wantedState = this.shouldWeather(state, pos, (class_1937)serverLevel) ? WeatheringState.TRUE : WeatheringState.FALSE;
                if (state.method_11654(WEATHERABLE) != wantedState) {
                    serverLevel.method_8652(pos, (class_2680)state.method_11657(WEATHERABLE, (Comparable)((Object)wantedState)), 2);
                    if (wantedState == WeatheringState.TRUE) {
                        level.method_39279(pos, state.method_26204(), 1);
                    }
                }
            }
        }
    }

    public static class_2680 setStable(class_2680 state) {
        if (state.method_28498(WEATHERABLE)) {
            state = (class_2680)state.method_11657(WEATHERABLE, (Comparable)((Object)WeatheringState.STABLE));
        }
        return state;
    }

    public static enum WeatheringState implements class_3542
    {
        FALSE,
        TRUE,
        STABLE;


        public boolean isWeathering() {
            return this == TRUE;
        }

        public boolean isStable() {
            return this == STABLE;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

